<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}

$file = __DIR__ . "/appearance.json";
if (!file_exists($file)) {
    file_put_contents($file, json_encode([
        "background" => "",
        "logo" => "",
        "banners" => [],
        "button_style" => "",
        "provider_style" => "",
        "card_style" => "",
        "table_full_style" => ""
    ], JSON_PRETTY_PRINT));
}
$data = json_decode(file_get_contents($file), true) ?: [];

// Upload Background
if (isset($_POST["upload_background"]) && !empty($_FILES["background"]["name"])) {
    $targetDir = __DIR__ . "/upload/";
    if (!is_dir($targetDir)) mkdir($targetDir);
    $filename = "bg_" . time() . "_" . basename($_FILES["background"]["name"]);
    $targetFile = $targetDir . $filename;
    if (move_uploaded_file($_FILES["background"]["tmp_name"], $targetFile)) {
        $data["background"] = "upload/" . $filename;
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
        header("Location: appearance_edit?msg=" . urlencode("Background berhasil diupload!"));
        exit;
    }
}

// Upload Logo
if (isset($_POST["upload_logo"]) && !empty($_FILES["logo"]["name"])) {
    $targetDir = __DIR__ . "/upload/";
    if (!is_dir($targetDir)) mkdir($targetDir);
    $filename = "logo_" . time() . "_" . basename($_FILES["logo"]["name"]);
    $targetFile = $targetDir . $filename;
    if (move_uploaded_file($_FILES["logo"]["tmp_name"], $targetFile)) {
        $data["logo"] = "upload/" . $filename;
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
        header("Location: appearance_edit?msg=" . urlencode("Logo berhasil diupload!"));
        exit;
    }
}

// Upload Banner
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["upload_banner"])) {
    if (!empty($_FILES["banner"]["name"])) {
        if (count($data["banners"] ?? []) >= 15) {
            header("Location: appearance_edit?msg=" . urlencode("Maksimal 15 banner sudah tercapai!"));
            exit;
        } else {
            $targetDir = __DIR__ . "/upload/";
            if (!is_dir($targetDir)) mkdir($targetDir);
            $filename = "banner_" . time() . "_" . basename($_FILES["banner"]["name"]);
            $targetFile = $targetDir . $filename;
            if (move_uploaded_file($_FILES["banner"]["tmp_name"], $targetFile)) {
                $data["banners"][] = "upload/" . $filename;
                file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
                header("Location: appearance_edit?msg=" . urlencode("Banner berhasil diupload!"));
                exit;
            }
        }
    }
}

// Hapus Banner
if ($_SERVER["REQUEST_METHOD"] === "GET" && isset($_GET["delete_banner"])) {
    $idx = intval($_GET["delete_banner"]);
    if (isset($data["banners"][$idx])) {
        unset($data["banners"][$idx]);
        $data["banners"] = array_values($data["banners"]);
    }
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
    header("Location: appearance_edit?msg=" . urlencode("Banner berhasil dihapus!"));
    exit;
}

// Simpan style
foreach (["button", "provider", "card", "table_full"] as $key) {
    if (isset($_POST["save_$key"])) {
        $styleKey = "{$key}_style";
        $data[$styleKey] = $_POST[$styleKey] ?? "";
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        header("Location: appearance_edit?msg=" . urlencode("Style $key berhasil diperbarui!"));
        exit;
    }
}

$msg = $_GET["msg"] ?? "";
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Tampilan</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 p-4 md:p-8">

    <h2 class="text-2xl font-bold mb-4">🎨 Kelola Tampilan</h2>
    <?php if (!empty($msg)): ?>
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'success',
                    title: <?php echo json_encode($msg); ?>,
                    showConfirmButton: false,
                    timer: 2500,
                    timerProgressBar: true
                });
            });
        </script>
    <?php endif; ?>

    <!-- Logo -->
    <div class="bg-white p-6 rounded shadow mb-6">
        <h3 class="text-xl font-semibold mb-3">Logo</h3>
        <?php if (!empty($data["logo"])): ?>
            <img src="<?php echo htmlspecialchars($data["logo"]); ?>" class="max-h-24 mb-3 rounded">
        <?php endif; ?>
        <form method="post" enctype="multipart/form-data" class="space-y-3">
            <input type="file" name="logo" class="w-full border p-2 rounded" required>
            <button type="submit" name="upload_logo" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-500">Upload Logo</button>
        </form>
    </div>

    <!-- Banner -->
    <div class="bg-white p-6 rounded shadow mb-6">
        <h3 class="text-xl font-semibold mb-3">Banner (min 1, max 15)</h3>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-4">
            <?php foreach (($data["banners"] ?? []) as $i => $banner): ?>
                <div class="relative group">
                    <img src="<?php echo htmlspecialchars($banner); ?>" class="rounded shadow">
                    <a href="?delete_banner=<?php echo $i; ?>" 
                       class="btn-delete absolute top-1 right-1 bg-red-600 text-white px-2 py-1 text-xs rounded opacity-80 group-hover:opacity-100"
                       data-url="?delete_banner=<?php echo $i; ?>">Hapus</a>
                </div>
            <?php endforeach; ?>
        </div>
        <form method="post" enctype="multipart/form-data" class="space-y-3">
            <input type="file" name="banner" class="w-full border p-2 rounded" required>
            <button type="submit" name="upload_banner" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-500">Upload Banner</button>
        </form>
    </div>

    <!-- Background -->
    <div class="bg-white p-6 rounded shadow mb-6">
        <h3 class="text-xl font-semibold mb-3">Background</h3>
        <?php if (!empty($data["background"])): ?>
            <img src="<?php echo htmlspecialchars($data["background"]); ?>" class="w-full max-h-64 object-cover mb-3 rounded">
        <?php endif; ?>
        <form method="post" enctype="multipart/form-data" class="space-y-3">
            <input type="file" name="background" class="w-full border p-2 rounded" required>
            <button type="submit" name="upload_background" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-500">Upload Background</button>
        </form>
    </div>

    <!-- Custom CSS -->
    <div class="bg-white p-6 rounded shadow mb-6">
        <h3 class="text-xl font-semibold mb-3">⚙️ Custom CSS</h3>
        <div class="space-y-2">
            <?php
            $styleForms = [
                "button" => ".btn (Warna Tombol)",
                "provider" => ".btn-provider",
                "card" => ".card-content",
                "table_full" => "Tabel Lengkap"
            ];
            foreach ($styleForms as $key => $label):
                $styleKey = "{$key}_style";
            ?>
                <details class="border rounded">
                    <summary class="cursor-pointer px-4 py-2 bg-gray-200 hover:bg-gray-300 font-semibold"><?php echo $label; ?></summary>
                    <div class="p-4 space-y-3">
                        <form method="post" class="space-y-3">
                            <textarea name="<?php echo $styleKey; ?>" rows="4" 
                                      class="w-full border p-2 rounded preview-textarea" 
                                      data-preview="<?php echo $key; ?>"><?php echo htmlspecialchars($data[$styleKey] ?? ""); ?></textarea>
                            <button type="submit" name="save_<?php echo $key; ?>" 
                                    class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-500">💾 Simpan Style</button>
                        </form>
                        <div class="mt-4">
                            <p class="text-gray-600 text-sm mb-2">Preview:</p>
                            <div id="preview-<?php echo $key; ?>" class="p-4 border rounded">
                                <?php if ($key === "button"): ?>
                                    <button class="px-4 py-2">Contoh Tombol</button>
                                <?php elseif ($key === "provider"): ?>
                                    <div class="btn-provider px-4 py-2 inline-block">Contoh Provider</div>
                                <?php elseif ($key === "card"): ?>
                                    <div class="card-content p-4">Contoh Card Content</div>
                                <?php elseif ($key === "table_full"): ?>
                                    <table class="w-full">
                                        <thead><tr><th class="p-2">Header 1</th><th class="p-2">Header 2</th></tr></thead>
                                        <tbody><tr><td class="p-2">Data 1</td><td class="p-2">Data 2</td></tr></tbody>
                                    </table>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </details>
            <?php endforeach; ?>
        </div>
    </div>

    <a href="dashboard" class="inline-block mt-4 px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-500">⬅ Kembali ke Dashboard</a>

    <script>
    // Live preview update
    document.querySelectorAll('.preview-textarea').forEach(el => {
        el.addEventListener('input', function () {
            let previewId = 'preview-' + this.dataset.preview;
            let target = document.getElementById(previewId);
            if (target) {
                target.querySelectorAll('*').forEach(child => {
                    child.style = this.value;
                });
            }
        });
    });

    // SweetAlert konfirmasi hapus
    document.querySelectorAll('.btn-delete').forEach(btn => {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            let url = this.getAttribute('data-url');
            Swal.fire({
                title: 'Yakin hapus?',
                text: "Data ini tidak bisa dikembalikan!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Ya, hapus!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            });
        });
    });
    </script>

</body>
</html>
